@echo off
setlocal
:: Em alguns ambientes, é necessário mudar para o diretório onde este .bat se localiza:
pushd %~dp0

set RANDFILE=.rnd

cls
@echo Criando estrutura basica...
if not exist certs md certs
if not exist private md private

@echo.
@echo (1/9) Criando parametros dh
openssl dhparam -outform PEM -out certs\dhparam.pem 1024

@echo.
@echo (2/9) Criando CA (Certificate Authority)...
openssl req -config ca.conf -newkey rsa:2048 -keyout private\ca_key.pem -new -x509 -days 1825 -sha256 -out certs\ca_cert.pem -extensions v3_ca

@echo.
@echo (3/9) Criando Chave do Certificado...
openssl genrsa -out private\server_key.pem 2048

@echo.
@echo (4/9) Criando CSR (Certificate Sign Request) para localhost...
openssl req -config localhost.conf -key private\server_key.pem -new -sha256 -out certs\localhost.csr

@echo.
@echo (5/9) Assinando certificado para localhost com a CA auto-assinada...
openssl x509 -req -days 1825 -CA certs\ca_cert.pem -CAkey private\ca_key.pem -CAcreateserial -in certs\localhost.csr -out certs\server_cert.pem -sha256 -extfile localhost.conf -extensions req_ext

@echo.
@echo (6/9) Verificando o certificado...
openssl verify -CAfile certs\ca_cert.pem certs\server_cert.pem

@echo.
@echo (7/9) Copiando arquivos...
copy certs\dhparam.pem ..\bin\
copy certs\server_cert.pem ..\bin\
copy private\server_key.pem ..\bin\

@echo.
@echo (8/9) Instalado CA (Certificate Authority)...
CertMgr.Exe -add certs\ca_cert.pem -all -s -r currentuser root

@echo.
@echo (9/9) Instalando agenteclisitef.exe como um servico do Windows. A instalacao sera valida apos a reinicializacao do computador.
@echo.
..\bin\agenteclisitef.exe -i


rem @echo on

pause
